-- Fichero Basketin.sql
-------------------------------------------------------------------
-- INSTALACIN de una Base de Datos Difusa sobre Baloncesto.     --
-- CREACIN de las TABLAS insercin de algunas tuplas en ellas,  --
-- as como creacin de elementos en la FMB de esta Bd.          --
-- Para la instalacin no hace falta desinstalarla previamente.  --
-------------------------------------------------------------------
-- Para que salgan los mensajes (de put_line) al instalar desde FSQL*Plus:
set serveroutput on
-- Para que salgan (o no) las ordenes a ejecutar: set echo on
set echo off
-- Para que no salgan los mensajes cuando todo va bien (los errores si salen):
set feedback off

exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> ****************************************** <<<<');
exec dbms_output.put_line('>>>> **** INSTALACIN de una Base de Datos **** <<<<');
exec dbms_output.put_line('>>>> **** Difusa sobre Baloncesto.         **** <<<<');
exec dbms_output.put_line('>>>> ****************************************** <<<< by J. Galindo G.');
exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> NOTAS:');
exec dbms_output.put_line('>>>>   - Es requisito indispensable que est instalado FIRST (tablas de la FMB...).');
exec dbms_output.put_line('>>>>   - No importa si se producen errores al intentar borrar');
exec dbms_output.put_line('>>>>     TABLAS que no existan (ORA-00942).');
exec dbms_output.put_line('>>>>   - Cualquier otro error podr impedir la correcta ejecucin del Servidor FSQL.');
exec dbms_output.put_line('>>>>     En ese caso revise el cdigo del error y el lugar donde ha ocurrido.');
exec dbms_output.put_line('>>>>');

exec dbms_output.put_line('>>>> Borrando y Creando tabla PLAYERS...');
DROP   TABLE PLAYERS;
CREATE TABLE PLAYERS(
  PLAYER VARCHAR2(60) NOT NULL,
  TEAM   VARCHAR2(30) NOT NULL,
  HEIGHTT NUMBER(1) NOT NULL,
  HEIGHT1 NUMBER(3),
  HEIGHT2 NUMBER(3),
  HEIGHT3 NUMBER(3),
  HEIGHT4 NUMBER(3),
  QUALITYT NUMBER(1) NOT NULL,
  QUALITY1 NUMBER(3),
  QUALITY2 NUMBER(3),
  QUALITY3 NUMBER(3),
  QUALITY4 NUMBER(3));

exec dbms_output.put_line('>>>> Borrando y Creando tabla SEARCH...');
DROP   TABLE SEARCH;
CREATE TABLE SEARCH(
  HEIGHTT NUMBER(1) NOT NULL,
  HEIGHT1 NUMBER(3),
  HEIGHT2 NUMBER(3),
  HEIGHT3 NUMBER(3),
  HEIGHT4 NUMBER(3),
  QUALITYT NUMBER(1) NOT NULL,
  QUALITY1 NUMBER(3),
  QUALITY2 NUMBER(3),
  QUALITY3 NUMBER(3),
  QUALITY4 NUMBER(3));


DECLARE
  t_PLAYERS  NUMBER;
  t_SEARCH   NUMBER;
  c_PHEIGHT  NUMBER;
  c_PQUALITY NUMBER;
  c_SHEIGHT  NUMBER;
  c_SQUALITY NUMBER;
BEGIN
  dbms_output.put_line('>>>> Insertando valores en la FMB sobre esta Bd Difusa...');
  -- Calcular OBJ# para las tablas con columnas difusas:
  SELECT object_id into t_PLAYERS FROM user_objects WHERE object_name='PLAYERS';
  SELECT object_id into t_SEARCH FROM user_objects WHERE object_name='SEARCH';

  -- Calcular COL# de las columnas difusas:
  SELECT column_id into c_PHEIGHT
    FROM user_tab_columns WHERE table_name='PLAYERS' AND column_name='HEIGHTT';
  SELECT column_id into c_PQUALITY
    FROM user_tab_columns WHERE table_name='PLAYERS' AND column_name='QUALITYT';
  SELECT column_id into c_SHEIGHT
    FROM user_tab_columns WHERE table_name='SEARCH' AND column_name='HEIGHTT';
  SELECT column_id into c_SQUALITY
    FROM user_tab_columns WHERE table_name='SEARCH' AND column_name='QUALITYT';

  -- Atributos con tratamiento difuso: Tipos 1, 2  3
  INSERT into FCL values (t_PLAYERS,c_PHEIGHT,2,1,USER||'.PLAYERS.HEIGHT');
  INSERT into FCL values (t_PLAYERS,c_PQUALITY,2,1,USER||'.PLAYERS.QUALITY');
  INSERT into FCL values (t_SEARCH,c_SHEIGHT,2,1,USER||'.SEARCH.HEIGHT');
  INSERT into FCL values (t_SEARCH,c_SQUALITY,2,1,USER||'.SEARCH.QUALITY');

  -- Objetos para la tabla PLAYERS:
  INSERT into FOL values(t_PLAYERS,c_PHEIGHT,0,'SHORT',0);
  INSERT into FOL values(t_PLAYERS,c_PHEIGHT,1,'NORMAL',0);
  INSERT into FOL values(t_PLAYERS,c_PHEIGHT,2,'TALL',0);
  INSERT into FOL values(t_PLAYERS,c_PHEIGHT,3,'VERY_TALL',0);
  INSERT into FOL values(t_PLAYERS,c_PQUALITY,0,'BAD',0);
  INSERT into FOL values(t_PLAYERS,c_PQUALITY,1,'REGULAR',0);
  INSERT into FOL values(t_PLAYERS,c_PQUALITY,2,'GOOD',0);
  INSERT into FOL values(t_PLAYERS,c_PQUALITY,3,'VERY_GOOD',0);

  -- Objetos para la tabla SEARCH:
  INSERT into FOL values(t_SEARCH,c_SHEIGHT,0,'SHORT',0);
  INSERT into FOL values(t_SEARCH,c_SHEIGHT,1,'NORMAL',0);
  INSERT into FOL values(t_SEARCH,c_SHEIGHT,2,'TALL',0);
  INSERT into FOL values(t_SEARCH,c_SHEIGHT,3,'VERY_TALL',0);
  INSERT into FOL values(t_SEARCH,c_SQUALITY,0,'BAD',0);
  INSERT into FOL values(t_SEARCH,c_SQUALITY,1,'REGULAR',0);
  INSERT into FOL values(t_SEARCH,c_SQUALITY,2,'GOOD',0);
  INSERT into FOL values(t_SEARCH,c_SQUALITY,3,'VERY_GOOD',0);

  -- Definicin de las etiquetas lingsticas:
  INSERT into FLD values(t_PLAYERS,c_PHEIGHT,0,0,0,175,180);
  INSERT into FLD values(t_PLAYERS,c_PHEIGHT,1,175,180,185,195);
  INSERT into FLD values(t_PLAYERS,c_PHEIGHT,2,185,195,200,210);
  INSERT into FLD values(t_PLAYERS,c_PHEIGHT,3,200,210,1000,1000);
  INSERT into FLD values(t_SEARCH,c_SHEIGHT,0,0,0,175,180);
  INSERT into FLD values(t_SEARCH,c_SHEIGHT,1,175,180,185,195);
  INSERT into FLD values(t_SEARCH,c_SHEIGHT,2,185,195,200,210);
  INSERT into FLD values(t_SEARCH,c_SHEIGHT,3,200,210,1000,1000);

  INSERT into FLD values(t_PLAYERS,c_PQUALITY,0,0,0,5,10);
  INSERT into FLD values(t_PLAYERS,c_PQUALITY,1,5,10,15,20);
  INSERT into FLD values(t_PLAYERS,c_PQUALITY,2,10,20,30,45);
  INSERT into FLD values(t_PLAYERS,c_PQUALITY,3,30,35,1000,1000);
  INSERT into FLD values(t_SEARCH,c_SQUALITY,0,0,0,5,10);
  INSERT into FLD values(t_SEARCH,c_SQUALITY,1,5,10,15,20);
  INSERT into FLD values(t_SEARCH,c_SQUALITY,2,10,20,30,45);
  INSERT into FLD values(t_SEARCH,c_SQUALITY,3,30,35,1000,1000);

  -- Definicin de:	1) Mrgenes para valores APROX en cada columna y
  --				2) Distancia Mnima para afirmar en los comparadores MGT y MLT.
  INSERT into FAM values(t_PLAYERS,c_PHEIGHT,6,12);
  INSERT into FAM values(t_PLAYERS,c_PQUALITY,10,15);
  INSERT into FAM values(t_SEARCH,c_SHEIGHT,6,12);
  INSERT into FAM values(t_SEARCH,c_SQUALITY,10,15);

  dbms_output.put_line('>>>> Insertando valores en esta Bd Difusa...');
  -- *****  INSERCIONES de los valores de las tablas ***** --
  INSERT into PLAYERS values ('P1' ,'Crdoba',4,0,NULL,NULL,NULL,4,3,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P2' ,'Crdoba',4,3,NULL,NULL,NULL,4,0,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P3' ,'Granada',4,0,NULL,NULL,NULL,4,3,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P4' ,'Granada',4,3,NULL,NULL,NULL,4,0,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P5' ,'Granada',3,198,NULL,NULL,NULL,4,1,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P6' ,'Mlaga' ,4,0,NULL,NULL,NULL,4,3,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P7' ,'Mlaga' ,4,2,NULL,NULL,NULL,4,0,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P8' ,'Mlaga' ,4,3,NULL,NULL,NULL,4,3,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P9' ,'Sevilla',4,0,NULL,NULL,NULL,4,2,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P10','Sevilla',4,3,NULL,NULL,NULL,4,0,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P11','Sevilla',4,1,NULL,NULL,NULL,4,2,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P12','Cdiz'  ,4,3,NULL,NULL,NULL,4,3,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P13','Cdiz'  ,4,0,NULL,NULL,NULL,4,2,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P14','Almera',4,2,NULL,NULL,NULL,4,3,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P15','Almera',4,0,NULL,NULL,NULL,4,1,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P16','Huelva' ,4,2,NULL,NULL,NULL,4,3,NULL,NULL,NULL);
  INSERT into PLAYERS values ('P17','Jaen'   ,4,3,NULL,NULL,NULL,4,1,NULL,NULL,NULL);

  INSERT into SEARCH values (4,0,NULL,NULL,NULL,4,3,NULL,NULL,NULL);
  INSERT into SEARCH values (4,3,NULL,NULL,NULL,4,0,NULL,NULL,NULL);
--delete from players where player='P12';
  COMMIT;
END;
/

-- Mensaje de FIN:
exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> FIN de la INSTALACIN: Si existieron errores, revise su texto.');
exec dbms_output.put_line('>>>>');

-- Reestablecer los valores por defecto:
set serveroutput off
set feedback on
